/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.cf3270em;

import com.ibm.hwmca.base.cf3270em.Cf3270EmData;
import com.ibm.hwmca.base.cf3270em.Cf3270EmErrorIds;
import com.ibm.hwmca.fw.HException;
import com.ibm.hwmca.fw.log.FrameworkClassLogInfo;
import com.ibm.hwmca.fw.log.FrameworkLog;
import com.ibm.hwmca.fw.persist.PersistenceException;
import com.ibm.hwmca.fw.persist.PersistenceManager;
import com.ibm.hwmca.fw.shutdown.ShutdownListener;
import com.ibm.hwmca.fw.shutdown.ShutdownManager;
import com.ibm.hwmca.fw.shutdown.ShutdownRequest;
import com.ibm.hwmca.fw.system.StartupHook;
import com.ibm.hwmca.fw.tasklet.PanelTasklet;
import com.ibm.hwmca.fw.tasklet.PanelTaskletRequest;
import com.ibm.hwmca.fw.tasklet.PanelTaskletResponse;
import com.ibm.hwmca.fw.util.NativeProcess;
import com.ibm.hwmca.fw.util.NativeProcessParameters;
import com.ibm.hwmca.fw.util.Trace;
import java.io.IOException;
import java.util.Date;
import java.util.Iterator;

public class Cf3270EmStartupHook
extends StartupHook
implements Cf3270EmErrorIds,
ShutdownListener {
    private static final String TRACE_MASKT = "XEMUHOKT";
    private static final String TRACE_MASKF = "XEMUHOKF";
    private static final String TRACE_MASKD = "XEMUHOKD";
    private static final String LAUNCH_SCRIPT = "xlaunch";
    private static final String EMULATOR_PROG = "x3270";
    private static final String EMULATOR_PARM1 = "-reconnect";
    private static FrameworkClassLogInfo logInfo = new FrameworkClassLogInfo(-93, "Cf3270EmHook");
    Cf3270EmData data = null;

    public Cf3270EmStartupHook(PanelTasklet tasklet) {
        super(tasklet);
        Trace.trace(TRACE_MASKT, "<> Cf3270EmStartupHook constructor");
        try {
            this.data = (Cf3270EmData)PersistenceManager.getPersistenceManager().read("com.ibm.hwmca.base.cf3270em.Cf3270EmPersistentData");
        }
        catch (PersistenceException e) {
            Trace.trace(TRACE_MASKF, "Cf3270EmStartupHook: caught PersistenceException");
            Trace.trace(TRACE_MASKF, e);
        }
    }

    public void service(PanelTaskletRequest request, PanelTaskletResponse response) {
        Trace.trace(TRACE_MASKT, "-> Cf3270EmStartupHook.service(" + request + "," + response + ")");
        try {
            if (this.data != null) {
                if (request.isInitialRequest()) {
                    Trace.trace(TRACE_MASKF, " got initial request.");
                    try {
                        if (this.data.hosts.size() > 0) {
                            ShutdownManager.getShutdownManager().addShutdownListener(this);
                        }
                        Iterator it = this.data.hosts.keySet().iterator();
                        while (it.hasNext()) {
                            String hostIp = (String)it.next();
                            Boolean hostBool = (Boolean)this.data.hosts.get(hostIp);
                            if (!hostBool.booleanValue()) continue;
                            Cf3270EmStartupHook.startEmulator(hostIp);
                        }
                        this.finished(1);
                    }
                    catch (Throwable t) {
                        Trace.trace(TRACE_MASKF, " caught throwable " + t);
                        HException hexc = new HException(" general error starting 3270 emulators " + t);
                        new FrameworkLog(logInfo, 16, hexc).log();
                    }
                } else {
                    Trace.trace(TRACE_MASKF, " got non-initial request.");
                    this.finished(1);
                }
            } else {
                Trace.trace(TRACE_MASKF, " null data, assume not enabled.");
                this.finished(1);
            }
        }
        catch (Throwable t) {
            Trace.trace(TRACE_MASKF, " caught throwable " + t);
            HException hexc = new HException("3270Startup Hook exception");
            new FrameworkLog(logInfo, 32, hexc).log();
        }
        Trace.trace(TRACE_MASKT, "<- Cf3270EmStartupHook.service()");
    }

    static void startEmulator(String s) {
        Trace.trace(TRACE_MASKT, "-> startEmulator(" + s + ")");
        if (s == null || s.length() == 0) {
            Trace.trace(TRACE_MASKF, " null target[" + s + "], no emulator started ");
        } else {
            try {
                String[] parms = new String[]{LAUNCH_SCRIPT, EMULATOR_PROG, EMULATOR_PARM1, s};
                NativeProcessParameters nativeParms = new NativeProcessParameters(parms);
                nativeParms.setOrphan(true);
                Trace.trace(TRACE_MASKF, new Date().toString() + "   spawning: " + parms[0] + " " + parms[1] + " " + parms[3]);
                NativeProcess proc = NativeProcess.exec(nativeParms);
                Trace.trace(TRACE_MASKD, "   process spawned: " + proc);
                Thread.sleep(1000L);
            }
            catch (Throwable t) {
                Trace.trace(TRACE_MASKF, "   caught throwable " + t);
            }
        }
        Trace.trace(TRACE_MASKT, "<- startEmulator()");
    }

    public void shutdownStarting(ShutdownRequest request, long delay) {
        Trace.trace(TRACE_MASKT, "-> Cf3270EmStartupHook.shutdownStarting");
        try {
            Process p = Runtime.getRuntime().exec("killall -15 x3270");
            boolean done = false;
            int rc = 0;
            while (!done) {
                try {
                    rc = p.waitFor();
                    done = true;
                }
                catch (InterruptedException e) {}
            }
            Trace.trace(TRACE_MASKF, "Cf3270EmStartupHook.shutdownStarting: killall returned " + rc);
        }
        catch (IOException e) {
            Trace.trace(TRACE_MASKF, "Exception trying to killall x3270");
            Trace.trace(TRACE_MASKF, e);
        }
        Trace.trace(TRACE_MASKT, "<- Cf3270EmStartupHook.shutdownStarting");
    }
}

